<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends Frontend_Rest
{
   public $base_model = 'front/product_model';
   public $menu_ctl = 'product';
   protected $primary_key = 'product_id';

   function __construct()
   {
      parent::__construct();
   }

   public function get_product() {
      $product_category_id = $this->input->get('product_category_id');

      $listing = [];
      if(!empty($product_category_id)) {
         $this->load->model('front/product_model');
         $filter['product_category_id'] = $product_category_id;
         $listing = $this->product_model->listing_order($filter);
      }

      return $this->success($listing);
   }

   public function add_to_cart() {
      $product_item_id = $this->input->post('product_item_id');
      $product_id = $this->input->post('product_id');
      $qty = $this->input->post('qty');

      if(!empty($product_item_id) && !empty($product_id) && !empty($qty))
      {
         $current_cart = get_cookie(CART_COOKIE);
         if(!empty($current_cart)) {
            $current_item = json_decode($current_cart);
            $cart_item = [];
            $is_existing = FALSE;
            //org item
            foreach($current_item as $rs)
            {
               //existing
               if($rs->product_item_id == $product_item_id) {
                  $item = new stdClass();
                  $item->product_id = $rs->product_id;
                  $item->product_item_id = $rs->product_item_id;
                  $item->qty = $rs->qty;
                  $cart_item[] = $item;
                  $is_existing = TRUE;
               }
               else {
                  $item = new stdClass();
                  $item->product_id = $rs->product_id;
                  $item->product_item_id = $rs->product_item_id;
                  $item->qty = $rs->qty;
                  $cart_item[] = $item;
               }
            }
            //new item
            if(!$is_existing)
            {
               $item = new stdClass();
               $item->product_id = $product_id;
               $item->product_item_id = $product_item_id;
               $item->qty = $qty;
               $cart_item[] = $item;
            }
            set_cookie(CART_COOKIE, json_encode($cart_item), 60 * 60 * 24);
         }
         else {
            $cart_item = [];
            $item = new stdClass();
            $item->product_id = $product_id;
            $item->product_item_id = $product_item_id;
            $item->qty = $qty;
            $cart_item[] = $item;
            set_cookie(CART_COOKIE, json_encode($cart_item), 60 * 60 * 24);
         }
         return $this->successN( count($cart_item));
      }
      else {
         //return $this->failedN( 'Please input qty');
      }
   }

   function remove_cart()
   {
      $product_item_id = $this->input->post('product_item_id');
      $current_cart = get_cookie(CART_COOKIE);
      if(!empty($current_cart) && !empty($product_item_id)) {
         $current_item = json_decode($current_cart);
         $cart_item = [];
         foreach($current_item as $rs)
         {
            if($rs->product_item_id != $product_item_id) {
               $item = new stdClass();
               $item->product_id = $rs->product_id;
               $item->product_item_id = $rs->product_item_id;
               $item->qty = $rs->qty;
               $cart_item[] = $item;
            }
         }
         set_cookie(CART_COOKIE, json_encode($cart_item), 60 * 60 * 24);
      }
   }

   public function confirm()
   {
      $lang = $this->input->post('lang');
      $fullname = $this->input->post('fullname');
      $phone = $this->input->post('phone');
      $email = $this->input->post('email');
      $company = $this->input->post('company');
      $address = $this->input->post('address');
      $buyfor = $this->input->post('buyfor');
      $qty = $this->input->post('qty');
      $current_item = get_cookie(CART_COOKIE);

      if(!empty($current_item) && !empty($fullname) && !empty($phone) && !empty($email) && !empty($company) && !empty($address)) {
         $data = [];
         $data['page_menu'] = 'quotation';

         $data['fullname'] = input_to_sql($fullname);
         $data['phone'] = input_to_sql($phone);
         $data['email'] = input_to_sql($email);
         $data['company'] = input_to_sql($company);
         $data['address'] = input_to_sql($address);
         $data['buyfor'] = $buyfor == 1 ? ($lang =='th' ? 'ติดตั้งเอง' : 'End-user'):($lang == 'th' ? 'จำหน่าย' : 'Retailer/Distributor');

         $cart_item = [];
         if(!empty($current_item)) {
            $this->load->model('front/product_model');
            $this->load->model('front/product_item_model');
            foreach(json_decode($current_item) as $rs) {
               $item = new stdClass();
               $item->product_id = $rs->product_id;
               $item->product_item_id = $rs->product_item_id;
               $item->qty = $qty[$rs->product_item_id];
               $item->product = $this->product_model->read($rs->product_id);
               $item->product_item = $this->product_item_model->read($rs->product_item_id);
               $cart_item[] = $item;
            }
         }
         $data['cart_item'] = $cart_item;

         $message = $this->load->view('front/'.$lang.'/request-quotation-email', $data, TRUE);
         //echo $message;
         $this->load->library('email_sender');
         if(!empty(SETTING_RECIPIENT_ORDER)) {
            $to_email = explode(',', SETTING_RECIPIENT_ORDER);
            $to_email[] = $email;
            $result = $this->email_sender->send($to_email, ($lang == 'th' ? 'ขอใบเสนอราคา' : 'Request Quotation'), $message);
            if($result) {
               delete_cookie(CART_COOKIE);
               $this->success($result);
            }
            else {
               $this->failedN('ไม่สามารถส่งอีเมลได้ในขณะนี้ กรุณาติดต่อผู้่ดูและเว็บไซต์');
            }
         }
         else {
            $this->failedN('ขออภัย ไม่พบอีเมลของแอดมิน');
         }

      }
   }

   public function catalog_download()
   {
      $lang = input_to_sql($this->input->post('lang'));
      $fullname = input_to_sql($this->input->post('fullname'));
      $phone = input_to_sql($this->input->post('phone'));
      $email = input_to_sql($this->input->post('email'));
      $company = input_to_sql($this->input->post('company'));
      $product_catalog_id = input_to_sql($this->input->post('product_catalog_id'));
      $direct_contact = input_to_sql($this->input->post('direct_contact'));

      if(!empty($fullname) && !empty($phone) && !empty($email) && !empty($company) && !empty($product_catalog_id)) {

         $this->load->model('front/product_catalog_log_model');
         $this->load->model('front/product_catalog_model');

         $rs = $this->product_catalog_model->read($product_catalog_id);
         $product_catalog_title = $rs->title;
         $product_catalog_create = $rs->created_at;

         $link_download = base_url('product/catalog/'.base64_encode($product_catalog_id.":".$product_catalog_create.":".$product_catalog_title));
         //$link_download = 'https://www.fastenic.com/product/catalog/'.base64_encode($product_catalog_id.":".$product_catalog_create.":".$product_catalog_title);

         $data = [];
         $data['fullname'] = $fullname;
         $data['phone'] = $phone;
         $data['email'] = $email;
         $data['company'] = $company;
         $data['product_catalog_id'] = $product_catalog_id;
         $data['product_catalog_title'] = $product_catalog_title;
         $data['link_download'] = $link_download;
         $data['direct_contact'] = $direct_contact;

         $item = new stdClass();
         $item->fullname = $fullname;
         $item->phone = $phone;
         $item->email = $email;
         $item->company = $company;
         $item->product_catalog_id = $product_catalog_id;
         $item->link_download = $link_download;
         $item->direct_contact = $direct_contact;
         $item->created_by = 1;
         $this->product_catalog_log_model->create($item);

         $this->load->library('email_sender');
         $message = $this->load->view('front/'.$lang.'/product-catalog-email', $data, TRUE);
         //echo $message;
         $to_email[] = $email;

         if(!empty(SETTING_RECIPIENT_CATALOG)) {
            foreach (explode(',', SETTING_RECIPIENT_CATALOG) as $e) {
               $to_email[] = $e;
            }
         } 

         if($to_email) {
            $result = $this->email_sender->send($to_email, 'Product Catalog Download', $message);
            if($result) {
               $this->success($result);
            }
            else {
               $this->failedN('ไม่สามารถส่งอีเมลได้ในขณะนี้ กรุณาติดต่อผู้่ดูและเว็บไซต์');
            }
         }
      }
   }
}