<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Contact extends Frontend_Rest
{
   public $base_model = 'front/product_model';
   public $menu_ctl = 'product';
   protected $primary_key = 'product_id';

   function __construct()
   {
      parent::__construct();
   }

   public function confirm()
   {
      $lang = $this->input->post('lang');
      $fullname = $this->input->post('fullname');
      $phone = $this->input->post('phone');
      $company = $this->input->post('company');
      $message = $this->input->post('message');
      $email = $this->input->post('email');

      if(!empty($fullname) && !empty($phone)) {
         $data = [];
         $data['page_menu'] = 'quotation';

         $data['fullname'] = input_to_sql($fullname);
         $data['phone'] = input_to_sql($phone);
         $data['company'] = input_to_sql($company);
         $data['message'] = input_to_sql($message);
         $data['email'] = input_to_sql($email);

         $message = $this->load->view('front/'.$lang.'/contact-email', $data, TRUE);
         //echo $message;
         if(!empty(SETTING_RECIPIENT_CONTACT)) {
            $this->load->library('email_sender');
            $to_email = explode(',', SETTING_RECIPIENT_CONTACT);
            $to_email[] = $email;
            $result = $this->email_sender->send($to_email, ($lang == 'th' ? 'แบบฟอร์มติดต่อเรา' : 'Contact Form'), $message);
            if($result === TRUE) {
               $this->success($result);
            }
            else {
               $this->failedN('ไม่สามารถส่งอีเมลได้ในขณะนี้ กรุณาติดต่อผู้่ดูและเว็บไซต์ : ('.$result.')');
            }
         }
         else {
            $this->failedN('ไม่พบอีเมล์ปลายทาง');
         }
      }
   }
}