<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Article extends Frontend_Rest
{
   public $base_model = 'front/blog_model';
   public $menu_ctl = 'blog';
   protected $primary_key = 'blog_id';

   function __construct()
   {
      parent::__construct();
   }

   public function listing()
   {
      $lang = input_to_sql($this->input->get('lang'));
      $page = input_to_sql($this->input->get('page'));
      $blog_category_ids = $this->input->get('blog_category_ids');

      if(!empty($page)) {

         $this->load->model('front/blog_model');
         $this->load->model('front/blog_tag_model');
         $per_page = 9;
         $filter['blog_category_ids'] = $blog_category_ids;
         $filter['lang'] = $lang;
         $blog_all = count($this->blog_model->listing_order($filter));
         $blog_listing = $this->blog_model->listing_order($filter, $per_page, $per_page * ($page-1));
         $blog_tag_listing = $this->blog_tag_model->listing();
         if(!empty($blog_tag_listing)) {

            $blog_tags = [];
            $blog_tags_en = [];
            foreach ($blog_tag_listing as $rs) {
               $blog_tags[$rs->blog_id][] = '<a href="javascript:" class="btn-filter-category2" data-id="'.$rs->blog_category_id.'">'.$rs->blog_category.'</a>';
               $blog_tags_en[$rs->blog_id][] = '<a href="javascript:" class="btn-filter-category2" data-id="'.$rs->blog_category_id.'">'.$rs->blog_category_en.'</a>';
            }

            if (!empty($blog_listing)) {
               foreach ($blog_listing as $rs) {
                  $rs->blog_tags = $blog_tags[$rs->blog_id];
                  $rs->blog_tags_en = $blog_tags_en[$rs->blog_id];
                  $rs->title_th = output_text($rs->title_th);
                  $rs->title_en = output_text($rs->title_en);
                  $rs->thumb_url = blog_thumb_url($rs);
               }
            }
         }

         $data['blog_listing'] = $blog_listing;
         $data['blog_total_page'] = ceil($blog_all/$per_page);

         $this->success($data);
      }
   }
}