<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_catalog extends Restful_Controller
{
   public $base_model = 'bos/product_catalog_model';
   public $menu_ctl = 'product_catalog';
   protected $primary_key = 'product_catalog_id';

   function __construct()
   {
      parent::__construct();

      $this->pdf_config = UPLOAD_PRODUCT_CATALOG;
   }

   /**
    * Base : listing rows
    */
   public function listing_order()
   {
      if(!empty($this->input->get('filters')))
      {
         foreach($this->input->get('filters') as $key=>$val)
         {
            $this->filters_listing[$key] = input_to_sql($val);
         }
      }

      $listing = $this->model->listing($this->filters_listing);

      if(!empty($listing))
      {
         $primary_key = $this->primary_key;

         foreach($listing as $row)
         {
            if(!empty($row->pdf_ext))
            {
               $row->pdf_url = base_url('product/catalog/'.base64_encode($row->$primary_key.":".$row->created_at.":".$row->title));
            }
         }
      }

      $res = new stdClass();
      $res->rows = $listing;
      $res->total_row = count($listing);
      $res->all_row = count($listing);

      return $this->success($res);
   }

   public function read($is_return = false)
   {
      $id = input_to_sql($this->input->post('id'));
      if(!empty($id))
      {
         $row = $this->model->read($id, $this->filters_read);

         $primary_key = $this->primary_key;
         if(!empty($row))
         {
            if(!empty($row->pdf_ext))
            {
               $row->pdf_url = base_url(UPLOAD_PRODUCT_CATALOG[0][0].$row->$primary_key.'.'.$row->pdf_ext.'?t='.time());
            }
         }

         return $this->success($row);
      }
      else{
         return $this->failedN('Not found id.');
      }
   }

   /**
    * Base : delete rows
    */
   public function delete()
   {
      $ids = $this->input->post('ids');
      if(!empty($ids))
      {
         $this->model->delete($ids, $this->filters_delete);
         $this->_delete_pdf();
      }
      else{
         return $this->failedN('Not found ids.');
      }
   }
}