<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Blog extends Restful_Controller
{
   public $base_model = 'bos/blog_model';
   public $menu_ctl = 'blog';
   protected $primary_key = 'blog_id';
   protected $allow_html_fields = ['detail_th', 'detail2_th', 'detail_en', 'detail2_en'];

   function __construct()
   {
      parent::__construct();
      $this->thumb_config = UPLOAD_BLOG_THUMB;
      $this->cover_config = UPLOAD_BLOG_COVER;
   }

   /**
    * Listing order by order_id
    *
    * @return mixed
    */
   public function listing_order($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->db->order_by('n.show_home', 'ASC');
      $this->db->order_by('n.highlight', 'DESC');
      $this->db->order_by('n.orderid', 'ASC');
      return $this->listing($filters, $per_page, $offset);
   }

   /**
    * Base : read row
    */
   public function read($is_return = false)
   {
      $id = input_to_sql($this->input->post('id'));
      if(!empty($id))
      {
         $row = $this->model->read($id, $this->filters_read);

         if(!empty($row))
         {
            $row->thumb_url = ASSETS_NOIMG_320;
            $row->cover_url = ASSETS_NOIMG_320;
            $primary_key = $this->primary_key;
            if(!empty($row->thumb_ext))
            {
               $row->thumb_url = base_url($this->thumb_config[0][0].$row->$primary_key.'.'.$row->thumb_ext.'?t='.time());
            }
            if(!empty($row->cover_ext))
            {
               $row->cover_url = base_url($this->cover_config[0][0].$row->$primary_key.'.'.$row->cover_ext.'?t='.time());
            }
            if(!empty($row->special_ext))
            {
               $row->special_url = base_url($this->special_config[0][0].$row->$primary_key.'.'.$row->special_ext.'?t='.time());
            }
            if(!empty($row->pdf_ext))
            {
               $row->pdf_url = base_url($this->pdf_config[0][0].$row->$primary_key.'.'.$row->pdf_ext.'?t='.time());
            }

            if(!empty($row->detail_th)) {
               $row->detail_th = output_html($row->detail_th);
            }
            if(!empty($row->detail_en)) {
               $row->detail_en = output_html($row->detail_en);
            }
         }

         $this->load->model('bos/product_category_model');
         $this->load->model('bos/product_model');
         $this->load->model('bos/blog_tag_model');
         $this->load->model('bos/blog_product_model');
         $this->load->model('bos/blog_category_model');

         $blog_category = $this->blog_category_model->listing_order();
         $row->blog_category = $blog_category;

         $row->product_category = $this->product_category_model->listing_order();
         $product = $this->product_model->listing_order();
         $products = [];
         if(!empty($product)) {
            foreach ($product as $rs) {
               $products[$rs->product_category_id][] = $rs;
            }
         }
         $row->product = $products;

         $filterX['blog_id'] = $row->blog_id;
         $blog_tag = $this->blog_tag_model->listing($filterX);
         $blog_tags = [];
         if(!empty($blog_tag)) {
            foreach ($blog_tag as $rs) {
               $blog_tags[] = $rs->blog_category_id;
            }
         }
         $row->blog_tag = $blog_tags;

         $filterY['blog_id'] = $row->blog_id;
         $blog_product = $this->blog_product_model->listing($filterY);
         $blog_products = [];
         if(!empty($blog_product)) {
            foreach ($blog_product as $rs) {
               $blog_products[] = $rs->product_id;
            }
         }
         $row->blog_product = $blog_products;

         if($is_return) {
            return $row;
         }
         else {
            return $this->success($row);
         }
      }
      else{
         return $this->failedN('Not found id.');
      }
   }

   /**
    * Base : delete rows
    */
   public function delete()
   {
      $ids = $this->input->post('ids');
      if(!empty($ids))
      {
         $this->load->model('bos/blog_tag_model');
         $this->load->model('bos/blog_product_model');

         $this->model->delete($ids, $this->filters_delete);
         $this->_delete_cover();
         $this->_delete_pdf();
         $this->_delete_gallery();
         clear_main_cache();
         foreach($ids as $id) {
            $this->_delete_filters($id);

            $this->blog_tag_model->delete_parent('blog_id', $id);
            $this->blog_product_model->delete_parent('blog_id', $id);
         }
      }
      else{
         return $this->failedN('Not found ids.');
      }
   }

   /**
    * Base : create row
    */
   public function create()
   {
      $product_category = $_POST['blog_tag'];
      $product = $_POST['blog_product'];
      unset($_POST['blog_tag']);
      unset($_POST['blog_product']);

      $result = $this->create_record();
      if($result)
      {
         $this->create_product_category_item($result, $product_category);
         $this->create_product_item($result, $product);

         return $this->success($result);
      }
      else{
         return $this->failedN('Cannot create row.');
      }
   }

   /**
    * Base : update row
    */
   public function update()
   {
      $product_category = $_POST['blog_tag'];
      $product = $_POST['blog_product'];
      unset($_POST['blog_tag']);
      unset($_POST['blog_product']);

      $result = $this->update_record();
      if($result)
      {
         $this->create_product_category_item($result, $product_category);
         $this->create_product_item($result, $product);

         return $this->success($result);
      }
      else{
         return $this->failedN('Cannot update row.');
      }
   }

   private function create_product_category_item($blog_id, $product_category = []) {
      $this->load->model('bos/blog_tag_model');
      $this->blog_tag_model->delete_parent('blog_id', $blog_id);

      if(!empty($product_category)) {
         foreach ($product_category as $product_category_id) {

            $row = new stdClass();
            $row->blog_id = $blog_id;
            $row->blog_category_id = $product_category_id;
            $row->created_by = $this->login_user_id;

            $this->blog_tag_model->create($row);
         }
      }
   }

   private function create_product_item($blog_id, $products = []) {
      $this->load->model('bos/blog_product_model');
      $this->blog_product_model->delete_parent('blog_id', $blog_id);

      if(!empty($products)) {
         foreach ($products as $product_id) {

            $row = new stdClass();
            $row->blog_id = $blog_id;
            $row->product_id = $product_id;
            $row->created_by = $this->login_user_id;

            $this->blog_product_model->create($row);
         }
      }
   }
}