<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends Frontend_View
{
   function __construct()
   {
      parent::__construct();
   }

   public function index()
   {
      $data = [];
      $data['page_menu'] = 'home';

      $this->load->model('front/home_slider_model');
      $data['home_slider_listing'] = $this->home_slider_model->listing_order();

      $this->load->model('front/product_catalog_model');
      $data['product_catalog1'] = $this->product_catalog_model->read(1);
      $data['product_catalog2'] = $this->product_catalog_model->read(2);

      $this->load->model('front/blog_model');
      $this->load->model('front/blog_tag_model');

      $filter['lang'] = 'th';
      $blog_listing = $this->blog_model->listing_home(3, $filter);
      $blog_tag_listing = $this->blog_tag_model->listing();
      if(!empty($blog_tag_listing)) {

         $blog_tags = [];
         foreach ($blog_tag_listing as $rs) {
            $blog_tags[$rs->blog_id][] = '<a href="'.base_url('article?c='.$rs->blog_category_id).'">'.$rs->blog_category.'</a>';
         }

         if (!empty($blog_listing)) {
            foreach ($blog_listing as $rs) {
               $rs->blog_tags = $blog_tags[$rs->blog_id];
            }
         }
      }

      $data['blog_listing'] = $blog_listing;

      $this->view('index', $data);
   }
}