<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Article extends Frontend_View
{
   function __construct()
   {
      parent::__construct();
   }

   public function index()
   {
      $data = [];
      $data['page_menu'] = 'article';

      $this->load->model('front/blog_model');
      $this->load->model('front/blog_tag_model');
      $this->load->model('front/blog_category_model');
      $per_page = 9;
      $blog_all = count($this->blog_model->listing_order());
      $blog_listing = $this->blog_model->listing_order(null, $per_page, 0);

      $data['blog_listing'] = $blog_listing;
      $data['blog_total_page'] = ceil($blog_all/$per_page);
      $data['blog_category_listing'] = $this->blog_category_model->listing_order();

      $this->view('article', $data);
   }

   public function detail($rewrite_url)
   {
      $data = [];
      $data['page_menu'] = 'article';

      $this->load->model('front/blog_model');
      $this->load->model('front/blog_tag_model');
      $this->load->model('front/blog_product_model');

      $blog_row = $this->blog_model->read_url($rewrite_url);
      $data['blog_row'] = $blog_row;

      if(!empty($blog_row)) {
         $blog_tag_listing = $this->blog_tag_model->listing();
         $blog_tag_ids = [];
         $blog_tags = [];
         if(!empty($blog_tag_listing)) {

            foreach ($blog_tag_listing as $rs) {
               $blog_tags[$rs->blog_id][] = '<a href="'.base_url('article?c='.$rs->blog_category_id).'">'.$rs->blog_category.'</a>';
               $blog_tag_ids[$rs->blog_id][] = $rs->blog_category_id;
            }

            if (!empty($blog_row)) {
               $blog_row->blog_tags = $blog_tags[$blog_row->blog_id];
            }
         }

         $this->meta_title = $blog_row->title_th;
         $this->meta_keywords = !empty($blog_row->blog_tags) ? implode(', ', $blog_row->blog_tags) : '';
         $this->meta_description = $blog_row->intro_th;
         $this->thumb_url = blog_thumb_url($blog_row);

         $blog_blog_category_ids = $blog_tag_ids[$blog_row->blog_id];
         $blog_relate = [];
         if(!empty($blog_blog_category_ids)) {
            $filterX['blog_category_ids'] = $blog_blog_category_ids;
            $blog_tag_lists = $this->blog_tag_model->listing($filterX);
            $blog_relate_ids = [];
            if($blog_tag_lists) {
               foreach($blog_tag_lists as $rs) {
                  if($rs->blog_id != $blog_row->blog_id) {
                     $blog_relate_ids[] = $rs->blog_id;
                  }
               }
               $blog_relate_ids = array_unique($blog_relate_ids);
            }

            $blog_listing = $this->blog_model->listing_order();
            if(!empty($blog_listing)) {
               foreach($blog_listing as $rs) {
                  if(in_array($rs->blog_id, $blog_relate_ids) && $rs->blog_id !== $blog_row->blog_id && !empty($blog_tags[$rs->blog_id])) {
                     if($blog_tags[$rs->blog_id] == $blog_row->blog_tags) {
                        $rs->blog_tags = $blog_tags[$rs->blog_id];
                        $rs->blog_tags_count = count($blog_tags[$rs->blog_id]);
                        $blog_relate[] = $rs;
                     }
                  }
               }
               foreach($blog_listing as $rs) {
                  if(in_array($rs->blog_id, $blog_relate_ids) && $rs->blog_id !== $blog_row->blog_id && !empty($blog_tags[$rs->blog_id])) {
                     if(in_array($blog_tags[$rs->blog_id][0], $blog_row->blog_tags)) {
                        $rs->blog_tags = $blog_tags[$rs->blog_id];
                        $rs->blog_tags_count = count($blog_tags[$rs->blog_id]);
                        $blog_relate[] = $rs;
                     }
                  }
               }
               foreach($blog_listing as $rs) {
                  if(in_array($rs->blog_id, $blog_relate_ids) && $rs->blog_id !== $blog_row->blog_id && !empty($blog_tags[$rs->blog_id])) {
                     if(in_array($blog_row->blog_tags[0], $blog_tags[$rs->blog_id])) {
                        $rs->blog_tags = $blog_tags[$rs->blog_id];
                        $rs->blog_tags_count = count($blog_tags[$rs->blog_id]);
                        $blog_relate[] = $rs;
                     }
                  }
               }
            }
         }

         $filterY['blog_id'] = $blog_row->blog_id;
         $blog_product = $this->blog_product_model->listing_order($filterY);

         //usort($blog_relate, function($a, $b) {
         //   return $a->blog_tags_count < $b->blog_tags_count;
         //});
         //print_array($blog_relate);exit;
         $blog_relate = array_splice($blog_relate, 0, 3);
         $data['blog_relate'] = $blog_relate;
         $data['blog_product'] = $blog_product;
      }

      $this->view('article-detail', $data);
   }
}