<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/

$route['default_controller'] = 'home';
$route['404_override'] = 'error_404';
$route['translate_uri_dashes'] = FALSE;

/**
 * Router for Admin Office
 */
$route['bos/profile/edit'] = 'bos/profile/edit';
$route['bos/(:any)/print_pdf'] = 'bos/$1/print_pdf';
$route['bos/(:any)/print_html'] = 'bos/$1/print_html';
$route['bos/(:any)/add'] = 'bos/$1/add';
$route['bos/(:any)/edit'] = 'bos/$1/edit';
$route['bos/(:any)/view'] = 'bos/$1/view';
$route['bos/(:any)/(:any)'] = 'bos/$2/index';
$route['bos/(:any)/(:any)/listing'] = 'bos/$2/index';
$route['bos/(:any)/(:any)/add'] = 'bos/$2/add';
$route['bos/(:any)/(:any)/edit/(:num)'] = 'bos/$2/edit/$3';
$route['bos/(:any)/(:any)/view/(:num)'] = 'bos/$2/view/$3';

/**
 * Router for custom
 */
$route['bos/store/order/excel'] = 'bos/order/excel';

/**
 * Router for Shared
 */
$route['captcha/display'] = 'shared/captcha/display';
$route['captcha/text/(:any)'] = 'shared/captcha/text/$1';
$route['download/(:any)'] = 'shared/download/index/$1';
$route['sitemap'] = 'front/sitemap/index';


$route['product/catalog/(:any)'] = 'front/product_catalog_download/index/$1';

/**
 * Router for Frontend
 */
// --------------------------- THAI / Default --------------------------- //
$route['home'] = 'front/th/home/index';
$route['contact'] = 'front/th/contact/index';
$route['contact/thankyou'] = 'front/th/contact/thankyou';
$route['request-quotation'] = 'front/th/quotation/index';
$route['request-quotation/thankyou'] = 'front/th/quotation/thankyou';
$route['request-quotation/email'] = 'front/th/quotation/email';
$route['search'] = 'front/th/search/index';
$route['search-spec'] = 'front/th/search/spec';
$route['product/category/(:any)'] = 'front/th/product/category/$1';
$route['product/detail/(:any)'] = 'front/th/product/detail/$1';
$route['policy'] = 'front/th/content/policy';
$route['terms'] = 'front/th/content/terms';
$route['article'] = 'front/th/article/index';
$route['article/detail/(:any)'] = 'front/th/article/detail/$1';

// --------------------------- English --------------------------- //
$route['en/home'] = 'front/en/home/index';
$route['en/contact'] = 'front/en/contact/index';
$route['en/contact/thankyou'] = 'front/en/contact/thankyou';
$route['en/request-quotation'] = 'front/en/quotation/index';
$route['en/request-quotation/thankyou'] = 'front/en/quotation/thankyou';
$route['en/search'] = 'front/en/search/index';
$route['en/search-spec'] = 'front/en/search/spec';
$route['en/product/category/(:any)'] = 'front/en/product/category/$1';
$route['en/product/detail/(:any)'] = 'front/en/product/detail/$1';
$route['en/policy'] = 'front/en/content/policy';
$route['en/terms'] = 'front/en/content/terms';
$route['en/article'] = 'front/en/article/index';
$route['en/article/detail/(:any)'] = 'front/en/article/detail/$1';